#include<uart.h>
#include<p30fxxxx.h>

/* UART2 is defined in following devices */
#if defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__) || defined(__dsPIC30F5011__)	|| \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__)

/*********************************************************************
* Function Name     : ConfigIntUART2
* Description       : This function sets priority for  RX and TX 
*                     interrupt and enable/disables the interrupt
* Parameters        : unsigned int config enable/disable and priority
* Return Value      : None
*********************************************************************/

void ConfigIntUART2(unsigned int config)
{
    /* clear IF flags */
    IFS1bits.U2RXIF = 0;
    IFS1bits.U2TXIF = 0;

    /* set priority */
    IPC6bits.U2RXIP = 0x0007 & config;
    IPC6bits.U2TXIP = (0x0070 & config) >> 4;

    /* enable/disable interrupt */
    IEC1bits.U2RXIE = (0x0008 & config) >> 3;
    IEC1bits.U2TXIE = (0x0080 & config) >> 7;
}

#endif
